/*
 * MosP - Mind Open Source Project         http://www.mosp.jp/
 * Copyright (C) 1987-2009 MIND Co., Ltd.  http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.payroll.payment.action;

import java.util.Date;

import jp.mosp.common.common.BaseVo;
import jp.mosp.common.common.MospConst;
import jp.mosp.common.common.MospException;
import jp.mosp.common.common.MospUtility;
import jp.mosp.payroll.base.PayrollAction;
import jp.mosp.payroll.base.PayrollConst;
import jp.mosp.payroll.payment.vo.PaymentReportVo;

/**
 * ^[o͉ʂɂ鏈sB<br><br>
 * ȉ̃R}hB
 * <ul><li>
 * {@link #CMD_SHOW}
 * </li></ul>
 */
public class PaymentReportAction extends PayrollAction {
	
	/**
	 * ʕ\R}hB<br><br>
	 * ^vZ̔N擾A\B<br>
	 * ^vZ̔NȂꍇ́AVXeN\B<br>
	 */
	public static final String CMD_SHOW = "P1260";
	
	/**
	 * Action̏sB<br><br>
	 * ȉ̏sB
	 * <ul><li>
	 * {@link PayrollAction#PayrollAction()}
	 * </li></ul>
	 */
	public PaymentReportAction() {
		super();
	}
	
	/* (non-Javadoc)
	 * @see jp.mosp.common.common.BaseAction#getSpecificVo()
	 */
	@Override
	protected BaseVo getSpecificVo() {
		return new PaymentReportVo();
	}
	
	/**
	 * ANVB<br>
	 * ڍׂ́ANXQƁB<br>
	 */
	public void action() throws Exception {
		// VO擾yѐݒ
		prepareVo();
		if (this.cmd.equals(CMD_SHOW)) {
			// ʕ\
			show();
		} else {
			throw new MospException(MospConst.EX_CMD_INVALID);
		}
	}
	
	/**
	 * ʕ\sB<br><br>
	 * @throws Exception 
	 */
	private void show() throws Exception {
		// RlNV擾
		getConnection();
		// VO擾
		PaymentReportVo vo = (PaymentReportVo)getVo();
		// VXet擾
		Date sysDate = new Date();
		// v_EACeݒ
		vo.setPitYear(getYearArray(
				PayrollConst.DEFAULT_CURRENT_YEAR, MospUtility.getYear(sysDate) + 1));
		vo.setPitMonth(getMonthArray());
		vo.setPitOffice  (getOfficeArray());
		vo.setPitSection (getSectionArrayAll());
		// vZ擾
		Date current = getCurrent(PayrollConst.OFFICE_ALL, PayrollConst.CALC_PAYMENT);
		// vZmF
		if (current == null) {
			// VOtB[hݒ
			vo.setPltYear (MospUtility.getYear (sysDate));
			vo.setPltMonth(MospUtility.getMonth(sysDate));
			return;
		}
		// VOtB[hݒ
		vo.setPltYear (MospUtility.getYear (current));
		vo.setPltMonth(MospUtility.getMonth(current));
	}

}
